/*
 * Decompiled with CFR 0.152.
 */
package skeletonapplet;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.jar.JarFile;
import javax.swing.JApplet;
import javax.swing.ProgressMonitor;
import skeletonapplet.AppletWorker;
import skeletonapplet.Downloader;
import skeletonapplet.ExtendedLoader;
import skeletonapplet.FileInfo;
import skeletonapplet.FileInfoList;
import skeletonapplet.JreDatum;
import skeletonapplet.JreInfo;
import skeletonapplet.PacketTracerLocator;
import skeletonapplet.SimpleDownloader;
import skeletonapplet.Utilities;

public abstract class AbstractDelegatorApplet
extends JApplet
implements ActionListener {
    protected AppletWorker worker;
    protected PacketTracerLocator locator;
    protected File ptHome;
    protected JreInfo jreInfo;

    public void showStatus(String string) {
        try {
            super.showStatus(string);
        }
        catch (Throwable throwable) {
            Utilities.checkSwallow(throwable);
        }
    }

    public PacketTracerLocator getLocator() {
        return this.locator;
    }

    public void init() {
        super.init();
        try {
            String string = this.getParameter("ptaplayerfeatures");
            Utilities.setPtaPlayerFeaturesString(string == null ? "" : string);
        }
        catch (Throwable throwable) {
            Utilities.checkSwallow(throwable);
        }
        this.initializeJreInfo();
    }

    public void start() {
        super.start();
        if (this.worker == null) {
            this.instantiateWorker();
        }
        if (this.worker != null) {
            this.worker.start();
        }
        Utilities.saveBuffer();
    }

    public void startSimple() {
        super.start();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Utilities.saveBuffer();
        if (this.worker != null) {
            this.worker.actionPerformed(actionEvent);
        }
    }

    public boolean isActive() {
        return this.worker != null ? this.worker.isActive() : false;
    }

    public void performComplete() {
        if (this.worker != null) {
            this.worker.performComplete();
        }
    }

    public void performInterrupt() {
        if (this.worker != null) {
            this.worker.performInterrupt();
        }
    }

    public void performQuit() {
        if (this.worker != null) {
            this.worker.performQuit();
        }
    }

    public void stop() {
        Utilities.saveBuffer();
        if (this.worker != null) {
            this.worker.stop();
        }
        super.stop();
    }

    public void destroy() {
        Utilities.saveBuffer();
        if (this.worker != null) {
            this.worker.destroy();
        }
        super.destroy();
    }

    protected abstract boolean initializationError(Throwable var1);

    protected abstract boolean stopOnBrowserNameError();

    protected abstract boolean stopOnJarLoadingError(Throwable var1);

    protected abstract boolean stopOnJreVersionError();

    protected abstract boolean stopOnMissingPatchFilesError(String var1);

    protected abstract boolean stopOnNoJarFileError(String var1);

    protected abstract boolean stopOnNoPtHomeError();

    protected abstract boolean stopOnNoRawFileError(String var1);

    protected abstract boolean stopOnNoSecurityAccessError();

    protected abstract boolean stopOnNoWorkerError();

    protected File checkAndDownloadIfPossible(URL uRL, int n, FileInfo fileInfo, File file, File file2) {
        try {
            Utilities.logPrintln("checkAndDownloadIfPossible()");
            Utilities.logPrintln("\t\tbaseUrl = " + uRL);
            Utilities.logPrintln("\t\tnumberOfDownloadTries = " + n);
            Utilities.logPrintln("\t\tfileInfo = " + fileInfo);
            Utilities.logPrintln("\t\ttargetDirectory = " + file);
            Utilities.logPrintln("\t\tworkDirectory = " + file2);
            File file3 = new File(file, fileInfo.getBaseFileName());
            File file4 = new File(file2, fileInfo.getBaseFileName());
            Utilities.logPrintln();
            Utilities.logPrintln("...targetFile = " + file3);
            Utilities.logPrintln("...tempFile = " + file4);
            Utilities.logPrintln();
            try {
                if (file3 != null && file3.exists()) {
                    if (fileInfo.validate(file3)) {
                        Utilities.logPrintln("??? targetFile.exists() = " + file3.exists());
                        Utilities.logPrintln("\n==> " + file3);
                        return file3;
                    }
                    Utilities.logPrintln(file3 + " exists but is invalid; it will be ignored");
                }
            }
            catch (Throwable throwable) {
                Utilities.checkSwallow(throwable);
            }
            try {
                if (file4 != null && file4.exists()) {
                    if (fileInfo.validate(file4)) {
                        Utilities.logPrintln("??? tempFile.exists() = " + file4.exists());
                        Utilities.logPrintln("\n==> " + file4);
                        return file4;
                    }
                    Utilities.logPrintln(file4 + " exists but is invalid; it will be ignored");
                }
            }
            catch (Throwable throwable) {
                Utilities.checkSwallow(throwable);
            }
            if (Utilities.isFeatureDefined("autodownload")) {
                Utilities.logPrintln("??? Utilities.isFeatureDefined(\"autodownload\") = " + Utilities.isFeatureDefined("autodownload"));
                Utilities.logPrintln("??? AbstractDelegatorApplet 1 baseUrl = " + uRL);
                Downloader downloader = new Downloader(uRL, fileInfo, file2);
                byte[] byArray = this.download(downloader, fileInfo.getLength(), n);
                if (byArray != null) {
                    if (file3 != null) {
                        try {
                            Utilities.writeBytes(file3, byArray);
                            return file3;
                        }
                        catch (Throwable throwable) {
                            Utilities.check(throwable);
                        }
                    }
                    if (file4 != null) {
                        try {
                            Utilities.writeBytes(file4, byArray);
                            return file4;
                        }
                        catch (Throwable throwable) {
                            Utilities.check(throwable);
                        }
                    }
                }
            }
        }
        catch (Throwable throwable) {
            Utilities.checkSwallow(throwable);
        }
        Utilities.logPrintln("\n==> null");
        Utilities.saveBuffer();
        return null;
    }

    protected File checkAndDownloadIfPossible(URL uRL, int n, String string, File file, File file2) {
        try {
            Utilities.logPrintln("checkAndDownloadIfPossible()");
            Utilities.logPrintln("\t\tbaseUrl = " + uRL);
            Utilities.logPrintln("\t\tnumberOfDownloadTries = " + n);
            Utilities.logPrintln("\t\tname = " + string);
            Utilities.logPrintln("\t\ttargetDirectory = " + file);
            Utilities.logPrintln("\t\tworkDirectory = " + file2);
            String string2 = string;
            int n2 = string2.lastIndexOf("/");
            if (n2 >= 0) {
                string2 = string2.substring(n2 + 1);
            }
            File file3 = new File(file, string2);
            File file4 = new File(file2, string2);
            Utilities.logPrintln();
            Utilities.logPrintln("...targetFile = " + file3);
            Utilities.logPrintln("...tempFile = " + file4);
            Utilities.logPrintln();
            try {
                if (file3 != null && file3.exists()) {
                    Utilities.logPrintln("??? targetFile.exists() = " + file3.exists());
                    Utilities.logPrintln("\n==> " + file3);
                    return file3;
                }
            }
            catch (Throwable throwable) {
                Utilities.checkSwallow(throwable);
            }
            try {
                if (file4 != null && file4.exists()) {
                    Utilities.logPrintln("??? tempFile.exists() = " + file4.exists());
                    Utilities.logPrintln("\n==> " + file4);
                    return file4;
                }
            }
            catch (Throwable throwable) {
                Utilities.checkSwallow(throwable);
            }
            if (Utilities.isFeatureDefined("autodownload")) {
                Utilities.logPrintln("??? Utilities.isFeatureDefined(\"autodownload\") = " + Utilities.isFeatureDefined("autodownload"));
                SimpleDownloader simpleDownloader = new SimpleDownloader(uRL, string);
                byte[] byArray = simpleDownloader.download(n);
                if (byArray != null) {
                    if (file3 != null) {
                        try {
                            Utilities.writeBytes(file3, byArray);
                            return file3;
                        }
                        catch (Throwable throwable) {
                            Utilities.check(throwable);
                        }
                    }
                    if (file4 != null) {
                        try {
                            Utilities.writeBytes(file4, byArray);
                            return file4;
                        }
                        catch (Throwable throwable) {
                            Utilities.check(throwable);
                        }
                    }
                }
            }
        }
        catch (Throwable throwable) {
            Utilities.checkSwallow(throwable);
        }
        Utilities.logPrintln("\n==> null");
        Utilities.saveBuffer();
        return null;
    }

    protected boolean checkBrowserName() {
        String string = this.jreInfo.browserName().getDynamicValue();
        Utilities.logPrintln("checkBrowserName()");
        Utilities.logPrintln("... browserName = " + string);
        if (string == null || string.trim().length() == 0) {
            Utilities.println("\n==> true");
            return true;
        }
        String string2 = this.getParameter("disallowedBrowserNames");
        Utilities.logPrintln("... disallowedBrowserNamesString = " + string2);
        if (string2 == null || string2.trim().length() == 0) {
            Utilities.logPrintln("??? disallowedBrowserNamesString == null = " + (string2 == null));
            Utilities.logPrintln("??? disallowedBrowserNamesString.trim().length() == 0 = " + (string2.trim().length() == 0));
            Utilities.logPrintln("\n==> true");
            return true;
        }
        try {
            string = string.trim().toLowerCase();
            String[] stringArray = string2.split(";");
            boolean bl = true;
            for (int i = 0; i < stringArray.length; ++i) {
                if (!string.startsWith(stringArray[i].toLowerCase())) continue;
                Utilities.logPrintln("... disallowedBrowserNames[i] = " + stringArray[i]);
                Utilities.logPrintln("??? browserName.startsWith(disallowedBrowserNames[i].toLowerCase()) = " + string.startsWith(stringArray[i].toLowerCase()));
                bl = false;
            }
            Utilities.logPrintln("... nameIsOk = " + bl);
            Utilities.logPrintln("\n==> " + bl);
            return bl;
        }
        catch (Throwable throwable) {
            Utilities.checkSwallow(throwable);
            Utilities.logPrintln("\n==> true");
            return true;
        }
    }

    protected boolean checkJre() {
        Utilities.logPrintln("checkJre()");
        String string = this.getParameter("allowedjavaversions");
        Utilities.logPrintln("... allowedJavaVersionsString = " + string);
        if (string == null || string.trim().length() == 0) {
            Utilities.logPrintln("??? allowedJavaVersionsString == null = " + (string == null));
            Utilities.logPrintln("??? allowedJavaVersionsString.trim().length() == 0 = " + (string.trim().length() == 0));
            Utilities.logPrintln("\n==> true");
            return true;
        }
        try {
            String[] stringArray = string.split(";");
            String string2 = Utilities.getSpecificJavaVersion();
            Utilities.logPrintln("... specificVersion = " + string2);
            boolean bl = false;
            for (int i = 0; i < stringArray.length; ++i) {
                if (!string2.startsWith(stringArray[i])) continue;
                Utilities.logPrintln("... allowedJavaVersions[i] = " + stringArray[i]);
                Utilities.logPrintln("??? specificVersion.startsWith(allowedJavaVersions[i]) = " + string2.startsWith(stringArray[i]));
                bl = true;
            }
            Utilities.logPrintln("... versionIsOk = " + bl);
            Utilities.logPrintln("\n==> " + bl);
            return bl;
        }
        catch (Throwable throwable) {
            Utilities.checkSwallow(throwable);
            Utilities.logPrintln("\n==> true");
            return true;
        }
    }

    protected boolean checkSecurityAccess() {
        Utilities.logPrintln("checkSecurityAccess()");
        try {
            SecurityManager securityManager = System.getSecurityManager();
            Utilities.logPrintln("... security = " + securityManager);
            if (securityManager != null) {
                Utilities.logPrintln("??? security != null = " + (securityManager != null));
                RuntimePermission runtimePermission = null;
                runtimePermission = new RuntimePermission("getProtectionDomain");
                Utilities.logPrintln("... p = " + runtimePermission);
                securityManager.checkPermission(runtimePermission);
                runtimePermission = new RuntimePermission("getFileSystemAttributes");
                Utilities.logPrintln("... p = " + runtimePermission);
                securityManager.checkPermission(runtimePermission);
                securityManager.checkCreateClassLoader();
                securityManager.checkPropertiesAccess();
            }
            Utilities.logPrintln("\n==> true");
            return true;
        }
        catch (SecurityException securityException) {
            Utilities.logPrintln("\n==> false");
            return false;
        }
        catch (Throwable throwable) {
            Utilities.checkSwallow(throwable);
            Utilities.logPrintln("\n==> false");
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] download(Downloader downloader, int n, int n2) throws Exception {
        byte[] byArray = null;
        ProgressMonitor progressMonitor = null;
        try {
            progressMonitor = new ProgressMonitor(null, "Downloading updates to the PTSA Player.", "", 0, n);
            byArray = downloader.download(progressMonitor, 0, n2);
        }
        finally {
            progressMonitor.close();
        }
        return byArray;
    }

    protected String findPatchFiles(URL uRL, int n, List list, FileInfo fileInfo, FileInfoList fileInfoList, File file, File file2) throws Exception {
        Utilities.logPrintln("findPatchFiles()");
        Utilities.logPrintln("\t\tptaPlayerPatchInfos = " + fileInfoList);
        String string = null;
        List list2 = fileInfoList.getFileInfos();
        for (int i = 0; i < list2.size(); ++i) {
            FileInfo fileInfo2 = (FileInfo)list2.get(i);
            File file3 = this.checkAndDownloadIfPossible(uRL, n, fileInfo2, file, file2);
            JarFile jarFile = null;
            if (file3 != null && file3.exists()) {
                try {
                    jarFile = new JarFile(file3);
                }
                catch (Throwable throwable) {
                    Utilities.checkSwallow(throwable);
                }
            }
            if (jarFile != null) {
                list.add(jarFile);
                continue;
            }
            string = string == null ? fileInfo2.getBaseFileName() : string + "," + fileInfo2.getBaseFileName();
        }
        return string;
    }

    public int getParameter(String string, int n) {
        try {
            String string2 = this.getParameter(string);
            return Integer.parseInt(string2);
        }
        catch (Throwable throwable) {
            Utilities.check(throwable);
            return n;
        }
    }

    public String getParameter(String string, String string2) {
        Utilities.logPrintln("getParameter()");
        Utilities.logPrintln("\t\tname = " + string);
        Utilities.logPrintln("\t\tdefaultValue = " + string2);
        String string3 = this.getParameter(string);
        Utilities.logPrintln("... value = " + string3);
        Utilities.logPrintln("??? value == null = " + (string3 == null));
        Utilities.logPrintln("\n==> " + (string3 == null ? string2 : string3));
        return string3 == null ? string2 : string3;
    }

    protected void initializeJreInfo() {
        Utilities.logPrintln("initializeJreInfo()");
        try {
            this.jreInfo = JreInfo.soleInstance();
            this.setInformationalValueFromParameter(this.jreInfo.browserName(), "browsername");
            this.setInformationalValueFromProperty(this.jreInfo.browserNameFromJre(), "browser.name");
            this.setInformationalValueFromProperty(this.jreInfo.browserVendorFromJre(), "browser.vendor");
            this.setInformationalValueFromParameter(this.jreInfo.browserVersion(), "browserversion");
            this.setInformationalValueFromProperty(this.jreInfo.browserVersionFromJre(), "browser.version");
            this.setInformationalValueFromProperty(this.jreInfo.httpAgent(), "http.agent");
            this.setInformationalValueFromProperty(this.jreInfo.jreVendor(), "java.vendor");
            this.setInformationalValueFromProperty(this.jreInfo.jreVersion(), "java.version");
            this.setInformationalValueFromProperty(this.jreInfo.osArchitecture(), "os.arch");
            this.setInformationalValueFromProperty(this.jreInfo.osName(), "os.name");
            this.setInformationalValueFromProperty(this.jreInfo.osVersion(), "os.version");
            this.setInformationalValueFromParameter(this.jreInfo.serverBuild(), "serverbuildversion");
            this.setInformationalValueFromParameter(this.jreInfo.userAgent(), "useragent");
            this.jreInfo.skeletonBuild().setValueInformational("16.003");
            this.jreInfo.skeletonLoadDate().setValueInformational(new Date().toString());
        }
        catch (Throwable throwable) {
            Utilities.checkSwallow(throwable);
        }
        Utilities.logPrintln("\n==> void");
    }

    protected void initializeLocator(String string, String string2) throws Exception {
        Utilities.logPrintln("initializeLocator()");
        this.locator = new PacketTracerLocator(string, string2);
        this.ptHome = this.locator.getHomeDirectory();
        Utilities.logPrintln("... locator = " + this.locator);
        Utilities.logPrintln("... ptHome = " + this.ptHome);
        Utilities.logPrintln("\n==> void");
    }

    protected void instantiateWorker() {
        Utilities.logPrintln("instantiateWorker()");
        try {
            this.internalInstantiateWorker();
        }
        catch (Throwable throwable) {
            Utilities.checkSwallow(throwable);
            this.initializationError(throwable);
        }
        Utilities.logPrintln("\n==> void");
        Utilities.saveBuffer();
    }

    protected void internalInstantiateWorker() throws Exception {
        block53: {
            String string;
            String string2;
            Object object;
            int n = this.getParameter("numberofdownloadtries", 5);
            String string3 = this.getParameter("ptaplayerlocation");
            FileInfo fileInfo = new FileInfo();
            fileInfo.parseSpec(this.getParameter("ptaplayerjarspec"));
            FileInfoList fileInfoList = new FileInfoList(this.getParameter("ptaplayerpatchspecs"));
            FileInfo fileInfo2 = new FileInfo();
            fileInfo2.parseSpec(this.getParameter("skeletonjarspec"));
            String string4 = this.getParameter("workerclass");
            Utilities.logPrintln("... numberofdownloadtries = " + n);
            Utilities.logPrintln("... ptaPlayerDirectoryName = " + string3);
            Utilities.logPrintln("... ptaPlayerFileInfo = " + fileInfo);
            Utilities.logPrintln("... ptaPlayerPatchFileInfos = " + fileInfoList);
            Utilities.logPrintln("... skeletonFileInfo = " + fileInfo2);
            Utilities.logPrintln("... workerName = " + string4);
            boolean bl = false;
            boolean bl2 = true;
            boolean bl3 = true;
            String string5 = null;
            String string6 = null;
            File file = null;
            File file2 = null;
            File file3 = null;
            JarFile jarFile = null;
            ArrayList arrayList = new ArrayList();
            String string7 = "";
            Object var18_18 = null;
            URL uRL = this.getCodeBase();
            String string8 = this.getParameter("altcodebase");
            if (string8 != null) {
                try {
                    System.out.println("altCodeBaseString = <" + string8 + ">");
                    uRL = new URL(string8);
                }
                catch (Throwable throwable) {
                    Utilities.checkSwallow(throwable);
                }
            }
            try {
                if (this.checkJre()) {
                    bl = true;
                    this.jreInfo.jreVersion().setStatus(JreDatum.STATUS_OK);
                } else {
                    object = this.getParameter("minimumjavaversion");
                    string2 = object == null ? "" : "  Your JRE version should be at least " + (String)object + ".";
                    this.jreInfo.jreVersion().setStatus(JreDatum.STATUS_ERROR, "Your JRE version isn't sufficient to run the Packet Tracer Skills Assessment Player." + string2);
                    if (this.stopOnJreVersionError()) {
                        return;
                    }
                }
            }
            catch (Throwable throwable) {
                Utilities.check(throwable);
                bl2 = false;
                this.jreInfo.jreVersion().setValueUnavailable();
            }
            object = null;
            if (bl2 && this.checkSecurityAccess()) {
                try {
                    object = Utilities.getTemporaryDirectory();
                }
                catch (Throwable throwable) {
                    Utilities.check(throwable);
                    bl2 = false;
                }
            } else {
                bl2 = false;
            }
            if (bl2) {
                this.jreInfo.securityAccess().setValueOkay("Yes");
            } else {
                this.jreInfo.securityAccess().setValueError("No", "You didn't accept the signed jar, so it doesn't have sufficient security access to run completely.  You must close all of your browsers, return to this page, and when presented with the dialog asking about signed applet privileges, you must accept, or select \"Yes\", to give this program the security access it needs to succeed.");
                if (this.stopOnNoSecurityAccessError()) {
                    return;
                }
            }
            try {
                if (this.checkBrowserName()) {
                    bl3 = true;
                    this.jreInfo.browserName().setStatus(JreDatum.STATUS_OK);
                } else {
                    string2 = this.getParameter("disallowedBrowserNames");
                    string = "  Your browser can't be any one of the following: " + string2 + ".";
                    this.jreInfo.browserName().setStatus(JreDatum.STATUS_ERROR, "Your browser can't be used to take a Cisco Packet Tracer Skills Assessment." + string);
                    if (this.stopOnBrowserNameError()) {
                        return;
                    }
                }
            }
            catch (Throwable throwable) {
                Utilities.check(throwable);
            }
            if (bl2) {
                try {
                    string2 = "";
                    if (Utilities.isLinux()) {
                        Utilities.logPrintln("??? Utilities.isLinux() = " + Utilities.isLinux());
                        string2 = "linux";
                    } else if (Utilities.isWindows()) {
                        Utilities.logPrintln("??? Utilities.isWindows() = " + Utilities.isWindows());
                        string2 = "windows";
                    }
                    Utilities.logPrintln("... parameterPrefix = " + string2);
                    string = string2 + "ptenvironmentvariables";
                    string5 = this.getParameter(string);
                    String string9 = string2 + "ptdirectories";
                    string6 = this.getParameter(string9);
                    Utilities.logPrintln("... envVarParameterName = " + string);
                    Utilities.logPrintln("... envVarParameterString = " + string5);
                    Utilities.logPrintln("... specificDirParameterName = " + string9);
                    Utilities.logPrintln("... specificDirParameterString = " + string6);
                    if (Utilities.isWindows()) {
                        Utilities.logPrintln("??? Utilities.isWindows() = " + Utilities.isWindows());
                        if (string5 == null || string5.length() == 0) {
                            Utilities.logPrintln("??? envVarParameterString == null = " + (string5 == null));
                            Utilities.logPrintln("??? envVarParameterString.length() == 0 = " + (string5.length() == 0));
                            string5 = "PT6HOME,PT5HOME,PT_LAUNCH_DIR,PTDIR";
                            Utilities.logPrintln("... envVarParameterString = " + string5);
                        }
                        if (string6 == null || string6.length() == 0) {
                            Utilities.logPrintln("??? specificDirParameterString == null = " + (string6 == null));
                            Utilities.logPrintln("??? specificDirParameterString.length() == 0 = " + (string6.length() == 0));
                            string6 = "C:\\Program Files\\Packet Tracer 6.0,C:\\Program Files (x86)\\Packet Tracer 6.0,C:\\Program Files\\Packet Tracer 5.3.3,C:\\Program Files (x86)\\Packet Tracer 5.3.3,C:\\Program Files\\Packet Tracer 5.3.2,C:\\Program Files (x86)\\Packet Tracer 5.3.2";
                            Utilities.logPrintln("... specificDirParameterString = " + string6);
                        }
                    }
                    this.initializeLocator(string5, string6);
                }
                catch (Throwable throwable) {
                    Utilities.checkSwallow(throwable);
                    Utilities.logPrintln("Error while locating Packet Tracer installation directory:\n" + Utilities.toString(throwable));
                }
            }
            ((File)object).mkdirs();
            file = this.checkAndDownloadIfPossible(uRL, n, fileInfo2, (File)object, (File)object);
            Utilities.logPrintln("... skeletonFile = " + file);
            if (file != null && file.exists()) {
                this.jreInfo.skeletonSize().setValueInformational(String.valueOf(file.length()));
            } else {
                this.jreInfo.skeletonSize().setValueError("N/A", "This required file was unable to be downloaded from the assessment server.");
            }
            if (this.ptHome != null) {
                this.jreInfo.ptDirectory().setValueOkay(this.ptHome.getCanonicalPath());
                file2 = new File(this.ptHome, string3);
                file3 = this.checkAndDownloadIfPossible(uRL, n, fileInfo, file2, (File)object);
                Utilities.logPrintln("... ptaPlayerDirectory = " + file2);
                Utilities.logPrintln("... rawFile = " + file3);
            } else {
                Utilities.logPrintln("??? ptHome == null = " + (this.ptHome == null));
                this.jreInfo.ptDirectory().setValueError("Not found", "Your current environment variables don't allow us to find a candidate Packet Tracer installation directory.  You may identify the proper Packet Tracer installation directory by setting the value of one of these operating system environment variables: " + string5 + "; or by adding Packet Tracer's \"bin\" subdirectory to your PATH environment variable.");
                if (this.stopOnNoPtHomeError()) {
                    return;
                }
            }
            if (file3 != null && file3.exists()) {
                this.jreInfo.ptaFileDate().setValueOkay(new Date(file3.lastModified()).toString());
                this.jreInfo.ptaSize().setValueOkay(String.valueOf(file3.length()));
                try {
                    jarFile = new JarFile(file3);
                    Utilities.logPrintln("... jarFile = " + jarFile);
                }
                catch (Throwable throwable) {
                    Utilities.checkSwallow(throwable);
                }
            } else {
                Utilities.logPrintln("??? rawFile != null = " + (file3 != null));
                this.jreInfo.ptaFileDate().setValueUnavailable();
                this.jreInfo.ptaSize().setValueUnavailable();
                this.jreInfo.missingPtaJarFile().setValue("Missing", JreDatum.STATUS_ERROR, fileInfo.getBaseFileName() + " is not part of Packet Tracer's current deployment, and it cannot be downloaded either into PT's deployment directory or into a temporary directory.");
                if (this.stopOnNoRawFileError(fileInfo.getBaseFileName())) {
                    return;
                }
            }
            if (jarFile != null) {
                this.jreInfo.missingPtaJarFile().setValueOkay("Yes");
            } else {
                this.jreInfo.ptaBuild().setValueError(fileInfo.getBaseFileName() + " is missing", "The candidate Packet Tracer installation directory doesn't include " + fileInfo.getBaseFileName() + " in its proper location.");
                if (file3 != null && file3.exists()) {
                    this.jreInfo.missingPtaJarFile().setValue("Invalid", JreDatum.STATUS_ERROR, fileInfo.getBaseFileName() + " has an invalid format, or there is a configuration problem that prevents it from being loaded.");
                }
                if (this.stopOnNoJarFileError(fileInfo.getBaseFileName())) {
                    return;
                }
            }
            if (file2 != null) {
                string7 = this.findPatchFiles(uRL, n, arrayList, fileInfo, fileInfoList, file2, (File)object);
                Utilities.logPrintln("... patchFiles = " + arrayList);
                Utilities.logPrintln("... missingPatchFiles = " + string7);
            }
            if (string7 == null || string7.trim().length() == 0) {
                this.jreInfo.missingPatchFiles().setValueOkay("Yes");
            } else {
                this.jreInfo.missingPatchFiles().setValueError("No", "The following required patch file(s) couldn't be downloaded from the assessment server and stored on your computer: " + string7 + ".");
                if (this.stopOnMissingPatchFilesError(string7)) {
                    return;
                }
            }
            if (bl && bl2 && file != null && file.exists() && jarFile != null) {
                try {
                    this.loadClasses(file, arrayList, jarFile, string4);
                }
                catch (Throwable throwable) {
                    Utilities.checkSwallow(throwable);
                    if (!this.stopOnJarLoadingError(throwable)) break block53;
                    return;
                }
            }
        }
        if (this.worker != null) {
            this.jreInfo.ptaBuild().setValueInformational(this.worker.getBuildVersion());
            this.jreInfo.ptaLoadDate().setValueInformational(this.worker.getLoadDate().toString());
            Utilities.logPrintln(">>> worker.setApplet()");
            this.worker.setApplet(this);
            Utilities.logPrintln(">>> worker.instanceCreation()");
            this.worker.instanceCreation();
            this.worker.init();
        } else {
            this.jreInfo.ptaBuild().setValueUnavailable();
            this.jreInfo.ptaLoadDate().setValueUnavailable();
            if (this.stopOnNoWorkerError()) {
                return;
            }
        }
    }

    protected void loadClasses(File file, List list, JarFile jarFile, String string) throws Exception {
        ExtendedLoader extendedLoader = new ExtendedLoader(this.getClass().getClassLoader(), file);
        Utilities.logPrintln("... extendedLoader = " + extendedLoader);
        for (int i = list.size() - 1; i >= 0; --i) {
            Utilities.logPrintln(">>> extendedLoader.addFile()");
            extendedLoader.addFile((JarFile)list.get(i));
        }
        extendedLoader.addFile(jarFile);
        Class<?> clazz = extendedLoader.loadClass(string);
        Object obj = clazz.newInstance();
        Utilities.logPrintln("... newClass = " + clazz);
        Utilities.logPrintln("... instance = " + obj);
        this.worker = (AppletWorker)obj;
    }

    protected void setInformationalValueFromParameter(JreDatum jreDatum, String string) {
        String string2 = null;
        try {
            string2 = this.getParameter(string);
        }
        catch (Throwable throwable) {
            Utilities.check(throwable);
        }
        if (string2 == null || string2.trim().length() == 0) {
            jreDatum.setValueUnavailable();
        } else {
            jreDatum.setValueInformational(string2);
        }
    }

    protected void setInformationalValueFromProperty(JreDatum jreDatum, String string) {
        String string2 = null;
        try {
            string2 = System.getProperty(string);
        }
        catch (Throwable throwable) {
            Utilities.check(throwable);
        }
        if (string2 == null || string2.trim().length() == 0) {
            jreDatum.setValueUnavailable();
        } else {
            jreDatum.setValueInformational(string2);
        }
    }
}

